import { getEmailFromSAP, getPartnerCodeFromSAP, getUnitsByPartnerCode } from "../services/sapService.js";


export const getUnitsController = async (req, res) => {
  try {
    // Get JWT from Authorization header
    const authHeader = req.headers.authorization;
    if (!authHeader) return res.status(401).json({ message: "Missing token" });
    const token = authHeader.split(" ")[1];
    const decoded = jwt.verify(token, process.env.JWT_SECRET);
    const nationalId = decoded.nationalId;

    // Get partnerCode from SAP
    const partnerCode = await getPartnerCodeFromSAP(nationalId);
    if (!partnerCode) return res.status(404).json({ message: "Partner code not found" });

    // Get units from SAP
    const units = await getUnitsByPartnerCode(partnerCode);
    return res.json({ units });
  } catch (err) {
    return res.status(500).json({ message: err.message });
  }
};
